/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLSERVERINFO
#define WAYLANDBACKEND_WLSERVERINFO 1
#include <string>
#include <wayland-client.h>
#include <wayland-client-protocol.h>
#include <layermanager/WaylandServerinfoClientProtocol.h>
#include <ilm/ilm_client.h>
#include "WLInterface.hpp"
#include "WLShellInterface.hpp"

struct serverinfo;
struct wl_event_queue;

namespace WaylandBackend
{

class WLServerInfo : public WLShellInterface
{
public:
    WLServerInfo(struct wl_event_queue *eventQ);
    virtual ~WLServerInfo();
    
    int init(struct wl_registry* registry, uint32_t name,
             const char* interface, uint32_t version);
    uint32_t getWLID();
    std::string& getWLName();
    
    std::string& getShellName() { return _shellName; }
    
    int surfaceCreate(struct wl_surface* wlSurface,
                      unsigned int surfaceId, unsigned int layerId,
                      unsigned int width, unsigned int height);
                              
    int surfaceDestroy(unsigned int surfaceId);
    
    int surfaceConfigure(unsigned int surfaceId, void *shellSurface,
                         int x, int y, unsigned int width,
                         unsigned int height);
    
    int surfaceConfigureSynchronous(unsigned int surfaceId,
                                    void *shellSurface, int x, int y,
                                    unsigned int width,
                                    unsigned int height);
    
    int surfaceSetVisbility(unsigned int surfaceId, void *shellSurface,
                            bool visible);
                                
private:
    struct serverinfo*          _lmServerInfo;
    struct wl_event_queue*      _wlEventQ;
    uint32_t                    _wlID;
    std::string                 _wlInterfaceName;
    uint32_t                    _lmConnect_id;
    std::string                 _shellName;
    
    static const struct serverinfo_listener serverinfo_listener;
    static void serverinfoCallback(void *data, struct serverinfo *pServerinfo,
                                   uint32_t client_handle);
    int getErrno(ilmErrorTypes ilm_error);
    
    void getPositiveSrcRect(int &sourceX, int &sourceY,
                            unsigned int &sourceWidth,
                            unsigned int &sourceHeight);
                            
    void getPositiveDestRect(int &destX, int &destY,
                             unsigned int &destWidth,
                             unsigned int &destHeight);

    void getVisibleLine(int &position, unsigned int &distance);
    void chooseVisibleLine(int &position, unsigned int &distance);

};

}

#endif

